// goredo -- djb's redo implementation on pure Go
// Copyright (C) 2020-2026 Sergey Matveev <stargrave@stargrave.org>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, version 3 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

package main

import (
	"embed"
	"flag"
	"fmt"
	"os"
	"strings"
)

const (
	Version  = "2.9.1"
	Warranty = `Copyright (C) 2020-2026 Sergey Matveev

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.`
)

//go:embed doc/cmd/goredo doc/cmd/redo*
var cmdDocs embed.FS

func usage(cmd string) {
	data, err := cmdDocs.ReadFile("doc/cmd/" + cmd)
	if err != nil {
		data, _ = cmdDocs.ReadFile("doc/cmd/goredo")
	}
	for line := range strings.SplitSeq(string(data), "\n") {
		if len(line) > 0 && line[len(line)-1] == '\r' {
			continue
		}
		fmt.Fprintln(os.Stderr, line)
	}
	fmt.Fprintln(os.Stderr, "Common options:")
	flag.PrintDefaults()
	fmt.Fprintln(os.Stderr, `
Additional environment variables:
  NO_COLOR -- disable messages colouring
  REDO_TOP_DIR -- do not search for .do above that directory
                  (it can contain .redo/top as an alternative)`)
	if cmd == CmdNameRedo || cmd == CmdNameRedoIfchange {
		fmt.Fprintln(os.Stderr, `
  REDO_NO_SYNC -- disable files/directories explicit filesystem syncing
  REDO_INODE_TRUST -- {none,ctime,mtime}, either do not trust inode
                      information at all (always check size and hash), or
                      trust its ctime (the default one), or be satisfied
                      with its mtime
  REDO_MAKE -- bmake/gmake/none(default) jobserver protocol compatibility`)
	}
}
