#!/bin/sh

testname=`basename "$0"`
test_description="Check that dependencies have correct relative path after cd"
. $SHARNESS_TEST_SRCDIR/sharness.sh
export REDO_TOP_DIR="`pwd`" REDO_NO_PROGRESS=1

mkdir -p bin src
cat >bin/default.do <<EOF
cd ../src
redo-ifchange src.go
echo bla bla bla
EOF
echo source code >src/src.go

test_expect_success Build "redo bin/cmd"
stat1=`stat bin/cmd`
test_expect_success Rebuild "redo-ifchange bin/cmd"
stat2=`stat bin/cmd`
test_expect_success "Was not rebuild" '[ "$stat1" = "$stat2" ]'

test_done
