#!/bin/sh

testname=`basename "$0"`
test_description="Check that non-renamed target copies mode from temporary target"
. $SHARNESS_TEST_SRCDIR/sharness.sh
export REDO_TOP_DIR="`pwd`" REDO_NO_PROGRESS=1

echo echo ok > foo.do
redo foo
test_expect_success "foo is non executable" '[ ! -x foo ]'
inode0=`perl -e '@s=stat "foo"; print "$s[1]\n"'`

cat > foo.do <<EOF
echo ok > \$3
chmod +x \$3
EOF
redo foo
test_expect_success "foo is executable" '[ -x foo ]'
inode1=`perl -e '@s=stat "foo"; print "$s[1]\n"'`
test_expect_success "foo was not renamed" '[ $inode0 = $inode1 ]'

test_done
