/*
go.cypherpunks.ru/tai64n -- Pure Go TAI64/TAI64N implementation
Copyright (C) 2020-2021 Sergey Matveev <stargrave@stargrave.org>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

package main

import (
	"bufio"
	"flag"
	"fmt"
	"log"
	"os"
	"time"

	"go.cypherpunks.ru/tai64n/v2"
)

func main() {
	log.SetFlags(0)
	flag.Usage = func() {
		fmt.Fprintf(
			flag.CommandLine.Output(),
			`Convert YYYY-MM-DD dates to TAI64 timestamps.
$ leapsecsdb > leapsecs.dat <<EOF
1972-07-01
1973-01-01
EOF
`,
		)
		flag.PrintDefaults()
	}
	flag.Parse()

	scanner := bufio.NewScanner(os.Stdin)
	var err error
	var t time.Time
	tai := new(tai64n.TAI64)
	for {
		if !scanner.Scan() {
			if err = scanner.Err(); err != nil {
				log.Fatalln(err)
			}
			break
		}
		t, err = time.Parse("2006-01-02", scanner.Text())
		if err != nil {
			log.Fatalln(err)
		}
		tai.FromTime(t)
		if _, err = os.Stdout.Write(tai[:]); err != nil {
			log.Fatalln(err)
		}
	}
}
