/*
goredo -- djb's redo implementation on pure Go
Copyright (C) 2020-2021 Sergey Matveev <stargrave@stargrave.org>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

package main

import (
	"os"
	"path"
	"path/filepath"
	"strings"
)

func sourcesWalker() ([]string, error) {
	tgts, err := targetsWalker(Cwd)
	if err != nil {
		return nil, err
	}
	srcs := make(map[string]struct{}, 1<<10)
	for _, tgt := range tgts {
		cwd, f := path.Split(tgt)
		fdDep, err := os.Open(path.Join(cwd, RedoDir, f+DepSuffix))
		if err != nil {
			return nil, err
		}
		depInfo, err := depRead(fdDep)
		fdDep.Close()
		for _, m := range depInfo.ifchanges {
			tgt = m["Target"]
			if !strings.HasSuffix(tgt, ".do") && isSrc(cwd, tgt) {
				pth, err := filepath.Abs(path.Join(cwd, tgt))
				if err != nil {
					panic(err)
				}
				srcs[cwdMustRel(pth)] = struct{}{}
			}
		}
	}
	tgts = make([]string, 0, len(srcs))
	for tgt := range srcs {
		tgts = append(tgts, tgt)
	}
	return tgts, nil
}
