/*
goredo -- djb's redo implementation on pure Go
Copyright (C) 2020-2021 Sergey Matveev <stargrave@stargrave.org>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

package main

import (
	"flag"
	"fmt"
	"os"
)

const (
	Version  = "1.4.0"
	Warranty = `Copyright (C) 2020-2021 Sergey Matveev

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.`
)

func usage(cmd string) {
	var d string
	switch cmd {
	case "redo":
		d = `Usage: redo [options] [target ...]

Forcefully and *sequentially* build specified targets.`
	case "redo-ifchange":
		d = `Usage: redo-ifchange target [...]

Build specified targets in parallel, if they are changed.
Record them as dependencies for current target.`
	case "redo-ifcreate":
		d = `Usage: redo-ifcreate target [...]

Record ifcreate dependency for current target. Unusable outside .do.`
	case "redo-always":
		d = `Usage: redo-always

Always build current target. Unusable outside .do.`
	case "redo-cleanup":
		d = `Usage: redo-cleanup [-dry-run] {full,log,tmp} [...]

Remove either all goredo's related temporary files, or kept stderr
logs, or everything (including .redo directories) related.`
	case "redo-log":
		d = `Usage: redo-log target [ | tai64nlocal ]

Display kept target's stderr with TAI64N timestamped lines. Only the
last build is kept. You must enable stderr keeping with either -logs,
or REDO_LOGS=1.`
	case "redo-dot":
		d = `Usage: redo-dot target [...]

Write dependency DOT graph to stdout.`
	case "redo-stamp":
		d = `Usage: redo-stamp < [$3]

Record stamp dependency for current target. Unusable outside .do.
Stamp dependency does not play any role, as all targets are hashed
anyway.`
	case "redo-whichdo":
		d = `Usage: redo-whichdo target

Display .do search paths for specified target. Exits successfully
if the last .do in output if the found existing one.`
	case "redo-targets":
		d = `Usage: redo-targets

List all currently known targets.`
	case "redo-sources":
		d = `Usage: redo-sources

List all currently known source files.`
	case "redo-ood":
		d = `Usage: redo-ood

List all currently known out-of-date targets.`
	default:
		d = `Usage: goredo -symlinks

goredo expects to be called through the symbolic link to it.
Available commands: redo, redo-always, redo-cleanup, redo-dot,
redo-ifchange, redo-ifcreate, redo-log, redo-stamp, redo-whichdo.`
	}
	fmt.Fprintf(os.Stderr, "%s\n\nCommon options:\n", d)
	flag.PrintDefaults()
	fmt.Fprintln(os.Stderr, `
Additional environment variables:
  NO_COLOR -- disable messages colouring
  REDO_NO_SYNC -- disable files/directories explicit filesystem syncing
  REDO_TOP_DIR -- do not search for .do above that directory
                  (it can contain .redo/top as an alternative)
  REDO_INODE_NO_TRUST -- do not trust inode information (except for size)
                         and always check file's hash`)
}
