/*
goredo -- djb's redo implementation on pure Go
Copyright (C) 2020-2021 Sergey Matveev <stargrave@stargrave.org>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

package main

import (
	"io"
	"os"
	"path"
	"path/filepath"
	"strings"
)

func targetsWalker(root string) ([]string, error) {
	root, err := filepath.Abs(root)
	if err != nil {
		panic(err)
	}
	dir, err := os.Open(root)
	if err != nil {
		return nil, err
	}
	defer dir.Close()
	tgts := make([]string, 0, 1<<10)
	for {
		fis, err := dir.Readdir(1 << 10)
		if err != nil {
			if err == io.EOF {
				break
			}
			return tgts, err
		}
		for _, fi := range fis {
			if !fi.IsDir() {
				continue
			}
			pth := path.Join(root, fi.Name())
			if fi.Name() == RedoDir {
				redoDir, err := os.Open(pth)
				if err != nil {
					return tgts, err
				}
				redoFis, err := redoDir.Readdir(0)
				if err != nil {
					return tgts, err
				}
				for _, redoFi := range redoFis {
					name := redoFi.Name()
					if strings.HasSuffix(name, DepSuffix) {
						name = cwdMustRel(root, name)
						tgts = append(tgts, name[:len(name)-len(DepSuffix)])
					}
				}
				redoDir.Close()
			} else {
				subTgts, err := targetsWalker(pth)
				tgts = append(tgts, subTgts...)
				if err != nil {
					return tgts, err
				}
			}
		}
	}
	return tgts, dir.Close()
}
