/*
goredo -- djb's redo implementation on pure Go
Copyright (C) 2020-2022 Sergey Matveev <stargrave@stargrave.org>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// Temporary files

package main

import (
	"os"
)

func tempfile(dir, prefix string) (*os.File, error) {
	tmp, err := os.CreateTemp(dir, TmpPrefix+prefix+".")
	if err != nil {
		return nil, err
	}
	err = os.Chmod(tmp.Name(), os.FileMode(0666&^UmaskCur))
	if err != nil {
		tmp.Close()
		return nil, err
	}
	return tmp, nil
}
