/*
goredo -- djb's redo implementation on pure Go
Copyright (C) 2020-2021 Sergey Matveev <stargrave@stargrave.org>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

package main

import (
	"log"
	"os"
	"path"
	"path/filepath"
)

func sourcesWalker(tgts []string) ([]string, error) {
	seen := make(map[string]struct{}, 1<<10)
	for _, tgt := range tgts {
		tgtAbsPath, err := filepath.Abs(path.Join(Cwd, tgt))
		if err != nil {
			panic(err)
		}
		cwd, f := path.Split(path.Join(Cwd, tgt))
		fdDep, err := os.Open(path.Join(cwd, RedoDir, f+DepSuffix))
		if err != nil {
			if os.IsNotExist(err) {
				continue
			}
			return nil, err
		}
		depInfo, err := depRead(fdDep)
		if err != nil {
			return nil, err
		}
		fdDep.Close()
		for _, m := range depInfo.ifchanges {
			depTgt := m["Target"]
			depTgtAbsPath, err := filepath.Abs(path.Join(cwd, depTgt))
			if err != nil {
				panic(err)
			}
			if isSrc(cwd, depTgt) {
				seen[cwdMustRel(depTgtAbsPath)] = struct{}{}
			} else if depTgtAbsPath != tgtAbsPath {
				subSrcs, err := sourcesWalker([]string{cwdMustRel(depTgtAbsPath)})
				if err != nil {
					log.Fatalln(err)
				}
				for _, p := range subSrcs {
					seen[p] = struct{}{}
				}
			}
		}
	}
	srcs := make([]string, 0, len(seen))
	for p := range seen {
		srcs = append(srcs, p)
	}
	return srcs, nil
}
