/*
goredo -- redo implementation on pure Go
Copyright (C) 2020-2021 Sergey Matveev <stargrave@stargrave.org>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

package main

import (
	"flag"
	"fmt"
	"os"
	"runtime"
	"strings"
)

const (
	Version  = "0.12.2"
	Warranty = `This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.`
)

func versionGet() string {
	return strings.Join([]string{
		"goredo", Version, "built with", runtime.Version(),
	}, " ")
}

func usage() {
	fmt.Fprintf(os.Stderr, versionGet()+`
Copyright (C) 2020-2021 Sergey Matveev
License GPLv3: GNU GPL version 3 <http://gnu.org/licenses/gpl.html>
This is free software: you are free to change and redistribute it.
There is NO WARRANTY, to the extent permitted by law.

redo, redo-{always,cleanup,dot,ifchange,ifcreate,log,stamp,whichdo} must
be linked to goredo executable. It determines the command by its own name.
You can create them by running: goredo -symlinks.

* redo [options] [target ...]
  forcefully and *sequentially* build specified targets
* redo-always
  always build current target. Unusable outside .do
* redo-cleanup {full,log,tmp} [...]
  remove either all goredo's related temporary files, or kept stderr
  logs, or everything (including .redo directories) related
* redo-dot target [...]
  write dependency DOT graph to stdout
* redo-ifchange target [...]
  build specified targets in parallel, if they are changed. Record them
  as dependencies for current target
* redo-ifcreate target [...]
  record ifcreate dependency for current target. Unusable outside .do
* redo-log target [ | tai64nlocal ]
  display kept target's stderr with TAI64N timestamped lines. Only the
  last build is kept. You must enable stderr keeping with either -logs,
  or REDO_LOGS=1
* redo-stamp < [$3]
  record stamp dependency for current target. Unusable outside .do.
  Stamp dependency does not play any role, as all targets are hashed
  anyway
* redo-whichdo target
  display .do search paths for specified target. Exits successfully
  if the last .do in output if the found existing one

Options:
`)
	flag.PrintDefaults()
	fmt.Fprintln(os.Stderr, `
Additional environment variables:
  NO_COLOR -- disable messages colouring
  REDO_NO_SYNC -- disable files/directories explicit filesystem syncing
  REDO_TOP_DIR -- do not search for .do above that directory
                  (it can contain .redo/top as an alternative)`)
}
