/*
go.cypherpunks.ru/tai64n -- Pure Go TAI64N implementation
Copyright (C) 2020 Sergey Matveev <stargrave@stargrave.org>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

package main

import (
	"bufio"
	"log"
	"os"
	"strings"
	"time"

	"go.cypherpunks.ru/tai64n"
)

func main() {
	log.SetFlags(0)
	scanner := bufio.NewScanner(os.Stdin)
	var err error
	var s string
	var sep int
	var t time.Time
	for {
		if !scanner.Scan() {
			if err = scanner.Err(); err != nil {
				log.Fatalln(err)
			}
			break
		}
		s = scanner.Text()
		if s[0] != '@' {
			os.Stdout.WriteString(s + "\n")
		}
		sep = strings.IndexByte(s, byte(' '))
		if sep == -1 {
			os.Stdout.WriteString(s + "\n")
		}
		t, err = tai64n.Decode(s[1:sep])
		if err != nil {
			log.Fatalln(err)
		}
		os.Stdout.WriteString(t.Format(tai64n.LocalFmt) + s[sep:] + "\n")
	}
}
